﻿using System.Windows.Controls;
using System.Windows.Interactivity;

namespace ValidationSample.Interactivity
{
    /// <summary>
    /// テキストが変更されるたびにバインディングソースを即時更新するビヘイビアです。
    /// </summary>
    public class UpdateSourceOnTextChangedBehavior : Behavior<TextBox>
    {
        protected override void OnAttached()
        {
            base.AssociatedObject.TextChanged += AssociatedObject_TextChanged;
            base.OnAttached();
        }

        protected override void OnDetaching()
        {
            base.AssociatedObject.TextChanged -= AssociatedObject_TextChanged;
            base.OnDetaching();
        }

        private void AssociatedObject_TextChanged(object sender, TextChangedEventArgs e)
        {
            var be = base.AssociatedObject.GetBindingExpression(TextBox.TextProperty);
            if (be != null)
            {
                be.UpdateSource();
            }
        }
    }
}