﻿using System;
using System.Windows.Input;
using Microsoft.Practices.Prism.Commands;
using Microsoft.Practices.Prism.Interactivity.InteractionRequest;

namespace ValidationSample.ViewModel
{
    public class MainPageViewModel //: NotificationObject(ViewModelからプロパティ値を変更しないため本サンプルでは不要)
    {
        private string _message;
        /// <summary>
        /// ②値が変更されたときにSubmitCommandのRaiseCanExecuteChangedを実行して、
        /// SubmitCommandの実行可否(≒OKボタンの活性状態)を再判定します。
        /// </summary>
        public string Message
        {
            get { return _message; }
            set
            {
                _message = value;
                _submitCommand.RaiseCanExecuteChanged();
            }
        }

        private DelegateCommand _submitCommand;
        /// <summary>
        /// ④コマンドが実行(≒OKボタンが押下)されたときにShowMessageRequestのRaiseを実行して、
        /// ShowMessageRequestにメッセージを渡します。
        /// </summary>
        public ICommand SubmitCommand
        {
            get
            {
                if (_submitCommand == null)
                {
                    _submitCommand = new DelegateCommand(
                        () => { _showMessageRequest.Raise(new Notification() { Title = "確定", Content = _message }); },
                        () => { return String.IsNullOrEmpty(_message) == false; }
                    );
                }
                return _submitCommand;
            }
        }

        private InteractionRequest<Notification> _showMessageRequest;
        /// <summary>
        /// ⑤SubmitCommandから受け取ったメッセージをビューに通知します。
        /// </summary>
        public IInteractionRequest ShowMessageRequest
        {
            get
            {
                if (_showMessageRequest == null)
                {
                    _showMessageRequest = new InteractionRequest<Notification>();
                }
                return _showMessageRequest;
            }
        }
    }
}